﻿using VA.TMP.Integration.VIMT.Messages.Mvi;
using VA.TMP.Integration.VIMT.Mvi.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Mvi.PipelineSteps.GetPersonIdentifiers
{
    /// <summary>
    /// Create Response step.
    /// </summary>
    public class CreateResponseStep : FilterBase<GetPersonIdentifiersStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(GetPersonIdentifiersStateObject state)
        {
            if (!string.IsNullOrEmpty(state.SelectedPersonFakeResponseType))
            {
                state.GetPersonIdentifiersResponseMessage.ExceptionMessage = "*****THIS IS FAKE DATA. DATA NOT SENT TO MVI*****";
                state.GetPersonIdentifiersResponseMessage.SerializedInstance = string.Empty;
            }
            else
            {
                state.GetPersonIdentifiersResponseMessage = state.ExceptionOccured
                    ? new GetPersonIdentifiersResponseMessage { ExceptionOccured = true, ExceptionMessage = state.ExceptionMessage }
                    : state.GetPersonIdentifiersResponseMessage;
            }
        }
    }
}